package gov.va.med.mhv.sm.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Type;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.sm.admin.enums.RelationTypeEnum;

@Entity
@Table(name = "MESSAGE_ACTIVITY")
@SelectBeforeUpdate(value=true) 
public class LogEntry extends AbstractBaseEntity{

	private static final long serialVersionUID = 520029124276543326L;
	
	@Id
	@Column(name = "ACTIVITY_ID")
	@GeneratedValue(strategy=GenerationType.SEQUENCE, generator="sequence")
	@SequenceGenerator(name="sequence", sequenceName="GEN_SMS_SEQ")
	private Long id;
	
	@Column(name = "ACTIVE", columnDefinition = "NUMBER")
	@Type(type = "org.hibernate.type.NumericBooleanType")
	private Boolean active;
	
	@Column(name = "ACTIVITY_TYPE")
	private String activityType;
	
	@Column(name = "ACTION")
	private Long action;
	
	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "DETAIL_VALUE")
	private String detail;

	@Column(name = "SECURE_MESSAGE_ID")
	private Long messageId;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;
	
	@Column(name = "PERFORMER_TYPE")
	private Long performerType;
	
	@Column(name = "STATUS")
	private Boolean status;
	
	@Column(name = "SYSTEM_ACCESS")
	private Long system_access;
	
	@Column(name = "TIU_CREATION_ID")
	private Long tiuCreationId;

	@Column(name = "SMS_USER_ID")
	private Long userId;

	public LogEntry(){
		this.active=true;
		this.createdDate=new Date();
		this.modifiedDate=new Date();
	}
	
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Boolean getActive() {
		return active;
	}

	public void setActive(Boolean active) {
		this.active = active;
	}

	public String getActivityType() {
		return activityType;
	}

	public void setActivityType(String activityType) {
		this.activityType = activityType;
	}

	public Long getAction() {
		return action;
	}

	public void setAction(Long action) {
		this.action = action;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public Long getMessageId() {
		return messageId;
	}

	public void setMessageId(Long messageId) {
		this.messageId = messageId;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPerformerType() {
		return performerType;
	}

	public void setPerformerType(Long performerType) {
		this.performerType = performerType;
	}

	public Boolean getStatus() {
		return status;
	}

	public void setStatus(Boolean status) {
		this.status = status;
	}

	public Long getSystem_access() {
		return system_access;
	}

	public void setSystem_access(Long system_access) {
		this.system_access = system_access;
	}

	public Long getTiuCreationId() {
		return tiuCreationId;
	}

	public void setTiuCreationId(Long tiuCreationId) {
		this.tiuCreationId = tiuCreationId;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}
	
}

